<?php
/**
 * StudyPanda API - Main Router
 * REST API endpoints for Flutter app
 */

require_once __DIR__ . '/config.php';

// Support both query parameter and path-based routing
$endpoint = '';
$action = '';
$id = null;

// Check for query parameter first (e.g., ?endpoint=auth/register)
if (isset($_GET['endpoint'])) {
    $parts = explode('/', $_GET['endpoint']);
    $endpoint = $parts[0] ?? '';
    $action = $parts[1] ?? '';
    $id = $parts[2] ?? null;
} else {
    // Fall back to path-based routing
    $requestUri = $_SERVER['REQUEST_URI'];
    $basePath = '/backend/api.php';
    $path = str_replace($basePath, '', parse_url($requestUri, PHP_URL_PATH));
    $path = trim($path, '/');
    $segments = explode('/', $path);
    $endpoint = $segments[0] ?? '';
    $action = $segments[1] ?? '';
    $id = $segments[2] ?? null;
}

$method = Request::method();

// Route to appropriate handler
switch ($endpoint) {
    case 'auth':
        require_once __DIR__ . '/api/auth.php';
        handleAuth($action, $method);
        break;
    case 'user':
        require_once __DIR__ . '/api/user.php';
        handleUser($action, $method, $id);
        break;
    case 'progress':
        require_once __DIR__ . '/api/progress.php';
        handleProgress($action, $method);
        break;
    case 'leaderboard':
        require_once __DIR__ . '/api/leaderboard.php';
        handleLeaderboard($action, $method);
        break;
    case 'friends':
        require_once __DIR__ . '/api/friends.php';
        handleFriends($action, $method, $id);
        break;
    case 'achievements':
        require_once __DIR__ . '/api/achievements.php';
        handleAchievements($action, $method);
        break;
    case 'missions':
        require_once __DIR__ . '/api/missions.php';
        handleMissions($action, $method);
        break;
    case 'sync':
        require_once __DIR__ . '/api/sync.php';
        handleSync($method);
        break;
    case 'multiplayer':
        require_once __DIR__ . '/api/multiplayer.php';
        handleMultiplayer($action, $method);
        break;
    case 'tournament':
        require_once __DIR__ . '/api/tournament.php';
        handleTournament($action, $method);
        break;
    case 'skill':
        require_once __DIR__ . '/api/skill_match.php';
        handleSkillMatch($action, $method);
        break;
    case 'anonymous':
        require_once __DIR__ . '/api/anonymous_sync.php';
        handleAnonymousSync($action, $method);
        break;
    default:
        Response::success([
            'api' => 'StudyPanda API',
            'version' => API_VERSION,
            'status' => 'running'
        ], 'API is running');
}
?>
